package ru.yandex.partner.libs.auth.exception.authentication;

import org.springframework.security.core.AuthenticationException;

import ru.yandex.partner.libs.exceptions.Translatable;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class AuthenticationI18nException extends AuthenticationException implements Translatable {
    private final GettextMsg i18nMessage;

    public AuthenticationI18nException(GettextMsg i18nMessage, Throwable t) {
        // вместо msg передаем заглушку
        super(null, t);
        this.i18nMessage = i18nMessage;
    }

    public AuthenticationI18nException(GettextMsg i18nMessage) {
        // вместо msg передаем заглушку
        super(null);
        this.i18nMessage = i18nMessage;
    }

    @Override
    public GettextMsg getI18nMessage() {
        return i18nMessage;
    }
}
