package ru.yandex.partner.libs.auth.exception.authentication;

import java.util.Map;

import ru.yandex.partner.libs.auth.exception.ExceptionWithMeta;
import ru.yandex.partner.libs.i18n.GettextMsg;

/**
 * Эта ошибка должна использоваться, если при аутентификации через "куки/blackbox"
 * нужно вернуть ошибку 401
 */
public class CookieAuthenticationI18nException extends AuthenticationI18nException implements ExceptionWithMeta {
    private final String loginUrl;

    public CookieAuthenticationI18nException(GettextMsg i18nMessage, String loginUrl) {
        super(i18nMessage);
        this.loginUrl = loginUrl;
    }

    @Override
    public Map<String, Object> getMeta() {
        return loginUrl == null ? null : Map.of("url", loginUrl);
    }
}
