package ru.yandex.partner.libs.auth.exception.authentication;

import java.util.Map;

import org.springframework.security.core.AuthenticationException;

import ru.yandex.partner.libs.auth.exception.ExceptionWithMeta;

public class NoAuthenticationDataException extends AuthenticationException implements ExceptionWithMeta {

    private final String loginUrl;

    public NoAuthenticationDataException(String msg, String loginUrl) {
        super(msg);
        this.loginUrl = loginUrl;
    }

    @Override
    public Map<String, Object> getMeta() {
        return loginUrl == null ? null : Map.of("url", loginUrl);
    }
}
