package ru.yandex.partner.libs.auth.facade;

import java.util.Optional;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.extservice.blackbox.BlackboxUserInfo;

@Service
public class AuthenticationFacade implements UserAuthenticationProvider {
    private static final String ENGLISH_LANG = "en";

    private Authentication getAuthentication() {
//        Другие способы добыть аутентификацию:
//        1. Внедрение в зависимость метода
//        2. ((org.springframework.security.core.Authentication) request.getUserPrincipal()).getPrincipal();
        return SecurityContextHolder.getContext().getAuthentication();
    }

    @Override
    public UserAuthentication getUserAuthentication() {
        try {
            Authentication authentication = getAuthentication();
            return authentication != null ? (UserAuthentication) authentication.getDetails() : null;
        } catch (ClassCastException e) {
            throw new IllegalStateException("Unexpected Authentication class. Check your call, this method must be " +
                    "called after AuthenticationFilter", e);
        }
    }

    public String getLang() {
        return Optional.ofNullable(getUserAuthentication())
                .map(UserAuthentication::getBlackboxUserInfo)
                .map(BlackboxUserInfo::getLanguage)
                .orElse(ENGLISH_LANG);

    }

    @Override
    public boolean userHasRight(String rightName) {
        return this.getUserAuthentication().userHasRight(rightName);
    }
}
