package ru.yandex.partner.libs.auth.filter;

import java.io.IOException;

import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.LocaleResolver;

/**
 * Фильтр, который ловит все исключения и красиво записывает их в ответ
 * На вход ему нужна реализация "писателя ошибок" ({@link ExceptionResponseWriter})
 */
public class ExceptionFormatterFilter extends OncePerRequestFilter {

    private final ExceptionResponseWriter exceptionResponseWriter;

    private LocaleResolver localeResolver;

    public ExceptionFormatterFilter(ExceptionResponseWriter exceptionResponseWriter) {
        this.exceptionResponseWriter = exceptionResponseWriter;
    }

    @Autowired
    public void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Override
    protected void doFilterInternal(
            @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response,
            @Nonnull FilterChain filterChain
    ) throws IOException {
        // this is workaround for i18n to work on authentication step
        if (localeResolver != null) {
            LocaleContextHolder.setLocale(localeResolver.resolveLocale(request));
        }
        try {
            filterChain.doFilter(request, response);
        } catch (Throwable e) {
            if (!response.isCommitted()) {
                exceptionResponseWriter.writeExceptionResponse(request, response, e);
            }
        }
    }

}
