package ru.yandex.partner.libs.auth.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;
import ru.yandex.partner.libs.exceptions.I18nResponseStatusException;

/**
 * Обработчик неуспешной аутентификации, который бросает ResponseStatusException
 * (реализации из spring security, как правило, куда-нибудь перенаправляют)
 */
public class ExceptionAuthenticationFailureHandler implements AuthenticationFailureHandler {

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response,
                                        AuthenticationException exception) {
        throw new I18nResponseStatusException(HttpErrorStatusEnum.ERROR__NEED_AUTH, exception);
    }

}
