package ru.yandex.partner.libs.auth.message;

import java.util.EnumMap;
import java.util.Map;

import javax.annotation.Nonnull;

import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxSessionIdException.BlackboxSessionIdStatus;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum AuthErrorMsg implements GettextMsg {
    NO_AUTH_DATA(msg("Authentication data not provided")),

    AUTH_COOKIE_STATUS_NEED_RESET(msg("Cookie needs reset")),
    AUTH_COOKIE_STATUS_EXPIRED(msg("Cookie has expired")),
    AUTH_COOKIE_STATUS_NOAUTH(msg("User is not authorized in this domain")),
    AUTH_COOKIE_STATUS_DISABLED(msg("User is blocked")),
    AUTH_COOKIE_STATUS_INVALID(msg("Cookie is invalid")),
    AUTH_COOKIE_STATUS_UNKNOWN(msg("Unknown cookie validation error")),

    SERVICE_TICKET_STATUS(msg("Incorrect service ticket status: %s")),
    USER_TICKET_STATUS(msg("Incorrect user ticket status: %s")),
    FORBIDDEN_HEADERS(msg("Forbidden headers: %s")),
    HEADER_MUST_BE_INTEGER_NUMBER(msg("Header '%s' must be integer number"));


    private static final String KEYSET_NAME = "java-auth-error-msg";

    private static final Map<BlackboxSessionIdStatus, AuthErrorMsg> BLACKBOX_STATUS_MESSAGE_MAP
            = new EnumMap<>(BlackboxSessionIdStatus.class);

    static {
        fillBlackboxStatusMessageMap();
    }

    private final GettextMsgPayload payload;

    AuthErrorMsg(GettextMsgPayload.Builder builder) {
        payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }

    public static AuthErrorMsg forBlackboxResponseStatus(BlackboxSessionIdStatus status) {
        return BLACKBOX_STATUS_MESSAGE_MAP.getOrDefault(status, AUTH_COOKIE_STATUS_UNKNOWN);
    }

    private static void fillBlackboxStatusMessageMap() {
        BLACKBOX_STATUS_MESSAGE_MAP.put(BlackboxSessionIdStatus.NEED_RESET, AUTH_COOKIE_STATUS_NEED_RESET);
        BLACKBOX_STATUS_MESSAGE_MAP.put(BlackboxSessionIdStatus.EXPIRED, AUTH_COOKIE_STATUS_EXPIRED);
        BLACKBOX_STATUS_MESSAGE_MAP.put(BlackboxSessionIdStatus.NOAUTH, AUTH_COOKIE_STATUS_NOAUTH);
        BLACKBOX_STATUS_MESSAGE_MAP.put(BlackboxSessionIdStatus.DISABLED, AUTH_COOKIE_STATUS_DISABLED);
        BLACKBOX_STATUS_MESSAGE_MAP.put(BlackboxSessionIdStatus.INVALID, AUTH_COOKIE_STATUS_INVALID);
    }

}
