package ru.yandex.partner.libs.auth.message;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum RestApiControllerMsg implements GettextMsg {
    FAKE_LOGIN_NOT_ALLOWED(msg("Fake login unallowed")),
    FAKE_LOGIN_ACCESS_DENIED(msg("Can't fake login. Access denied"));

    private static final String KEYSET_NAME = "lib__RestApi__Controller.pm";

    private final GettextMsgPayload payload;

    RestApiControllerMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
