package ru.yandex.partner.libs.auth.message;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum WebInterfaceMsg implements GettextMsg {
    BAD_FAKE_LOGIN(msg("Bad fake login"));

    private static final String KEYSET_NAME = "lib__WebInterface.pm";

    private final GettextMsgPayload payload;

    WebInterfaceMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
