package ru.yandex.partner.libs.auth.message;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum YandexCabinetMsg implements GettextMsg {
    INVALID_KEY(msg("Key is not valid"));

    private static final String KEYSET_NAME = "lib__QBit__Application__Model__API__Yandex__Cabinet.pm";

    private final GettextMsgPayload payload;

    YandexCabinetMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }

}
