package ru.yandex.partner.libs.auth.model;

import java.util.Set;

import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.feature.UserFeatureEnum;
import ru.yandex.partner.core.role.Role;
import ru.yandex.partner.libs.auth.RightHolder;
import ru.yandex.partner.libs.extservice.blackbox.BlackboxUserInfo;

import static com.google.common.base.Preconditions.checkNotNull;


/**
 * Класс хранит информацию о текущем пользователе, полученную из аутентификации
 */
public class UserAuthentication {
    private final AuthenticationMethod authenticationMethod;
    private final UserCredentials userCredentials;
    private final boolean selfAuth;

    private User internalUser;
    private BlackboxUserInfo blackboxUserInfo;

    public UserAuthentication(AuthenticationMethod authenticationMethod, UserCredentials userCredentials) {
        this.authenticationMethod = checkNotNull(authenticationMethod);
        this.userCredentials = checkNotNull(userCredentials);
        this.selfAuth = false;
    }

    public UserAuthentication(AuthenticationMethod authenticationMethod, UserCredentials userCredentials,
                              boolean selfAuth) {
        this.authenticationMethod = checkNotNull(authenticationMethod);
        this.userCredentials = checkNotNull(userCredentials);
        this.selfAuth = selfAuth;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return authenticationMethod;
    }

    public long getUid() {
        return userCredentials.getUid();
    }

    public String getLogin() {
        return userCredentials.getLogin();
    }

    public Set<Role> getRoles() {
        return userCredentials.getRoles();
    }

    public User getInternalUser() {
        return internalUser;
    }

    public void setInternalUser(User user) {
        this.internalUser = user;
    }

    public BlackboxUserInfo getBlackboxUserInfo() {
        return blackboxUserInfo;
    }

    public void setBlackboxUserInfo(BlackboxUserInfo blackboxUserInfo) {
        this.blackboxUserInfo = blackboxUserInfo;
    }

    public UserCredentials getUserCredentials() {
        return userCredentials;
    }

    /**
     * @return true - если мы сами обращаемся к себе по АПИ (Например, perl), false - иначе
     */
    public boolean isSelfAuth() {
        return selfAuth;
    }

    public boolean userHasRight(String rightName) {
        return rightName != null && userCredentials.checkRight(rightName);
    }

    public boolean userHasRight(RightHolder right) {
        return right != null && userCredentials.checkRight(right);
    }

    public boolean userHasRole(Role role) {
        return userCredentials.getRoles().contains(role);
    }

    public boolean userHasFeature(UserFeatureEnum userFeatureEnum) {
        return userCredentials.getFeatures().contains(userFeatureEnum.getFeatureName());
    }
}
