package ru.yandex.partner.libs.auth.model;

import java.util.Collection;
import java.util.Optional;

import javax.servlet.http.HttpServletRequest;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;

/**
 * Реализация интерфейса {@link Authentication}
 * В Spring security этот интерфейс содержит как данные для авторизации, так и объект,
 * описывающий авторизованного пользователя после того, как авторизация удалась.
 * В нашем случае данные для авторизации - это весь http-запрос,
 * а данные пользователя - объект {@link UserAuthentication}
 *
 * Возможно, этот класс стоит объединить с {@link UserAuthentication}
 */
public class UserAuthenticationHolder implements Authentication, CredentialsContainer {

    private UserAuthentication userAuthentication;
    private HttpServletRequest httpServletRequest;

    public UserAuthenticationHolder(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public UserAuthenticationHolder(UserAuthentication userAuthentication) {
        this.userAuthentication = userAuthentication;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    @Override
    public Object getCredentials() {
        return httpServletRequest;
    }

    @Override
    public Object getDetails() {
        return userAuthentication;
    }

    @Override
    public Object getPrincipal() {
        return null;
    }

    @Override
    public boolean isAuthenticated() {
        return userAuthentication != null;
    }

    @Override
    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        if (isAuthenticated) {
            throw new IllegalArgumentException();
        }
        userAuthentication = null;
    }

    @Override
    public String getName() {
        return Optional.ofNullable(userAuthentication)
                .map(UserAuthentication::getUserCredentials)
                .map(UserCredentials::getLogin)
                .orElse("");
    }

    @Override
    public void eraseCredentials() {
        httpServletRequest = null;
    }

    public UserAuthentication getUserAuthentication() {
        return userAuthentication;
    }

    public HttpServletRequest getHttpServletRequest() {
        return httpServletRequest;
    }
}
