package ru.yandex.partner.libs.auth.provider;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

import ru.yandex.partner.libs.auth.annotation.AuthenticationType;
import ru.yandex.partner.libs.auth.annotation.SupportsAuthType;
import ru.yandex.partner.libs.auth.exception.ForceFailureAuthenticationException;
import ru.yandex.partner.libs.auth.manager.DefaultPartnerAuthenticationManager;

/**
 * Адаптер для провайдера аутентификации, который позволяет обойти
 * стандартное поведение {@link org.springframework.security.authentication.ProviderManager}
 * и выкинуть 401 если хотя бы один провайдер выкинул {@link AuthenticationException}
 *
 * @see DefaultPartnerAuthenticationManager
 */
public class ForceFailureAuthenticationProviderAdapter implements AuthenticationProvider, SupportsAuthType {

    private final AuthenticationProvider actualProvider;

    public ForceFailureAuthenticationProviderAdapter(AuthenticationProvider actualProvider) {
        this.actualProvider = actualProvider;
    }

    public AuthenticationProvider getActualProvider() {
        return actualProvider;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            return actualProvider.authenticate(authentication);
        } catch (AuthenticationException ex) {
            throw new ForceFailureAuthenticationException(ex);
        }
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return actualProvider.supports(authentication);
    }

    @Override
    public AuthenticationType supportedAuthType() {
        return actualProvider instanceof SupportsAuthType
                ? ((SupportsAuthType) actualProvider).supportedAuthType()
                : null;
    }
}
