package ru.yandex.partner.libs.auth.provider.apikey.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ApiKeyResponse {
    private String error;
    private String result;

    @JsonProperty("key_info")
    private ApiKeyKeyInfo keyInfo;

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public ApiKeyKeyInfo getKeyInfo() {
        return keyInfo;
    }

    public void setKeyInfo(ApiKeyKeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public boolean isUserOk(ApiKeyUser user) {
        return user != null && user.getUid() != null && StringUtils.isNotBlank(user.getLogin());
    }
    /**
     * Проверяет, был ли ответ успешным
     * Условие - должно отсутствовать поле ошибки (error), поле result должно быть установлено в OK,
     * должны быть установлены и быть валидными поля key_info, key_info.user
     *
     * @return - true, если условие выполнено, иначе false
     */
    public boolean isOk() {
        return this.getError() == null && "OK".equals(this.getResult()) && this.getKeyInfo() != null &&
                isUserOk(this.getKeyInfo().getUser());
    }

    /**
     * Проверяет, что ошибка в запросе пользователя, а не в конфигурации приложения
     * @return - true, если текст ошибки "Key not found"
     */
    public boolean isKeyError() {
        return "Key not found".equals(this.getError());
    }
}
