package ru.yandex.partner.libs.auth.service;

import java.util.EnumMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxSessionIdException.BlackboxSessionIdStatus;

@Service
public class LoginUrlService {

    private static final String DEFAULT_LOGIN_URL = "/passport?mode=auth";
    private static final String FIX_LOGIN_URL = "/passport?mode=postregistration&create_login=1";
    private static final String RESET_COOKIE_URL = "/auth/update/?";

    private final String baseUrl;

    private final String defaultLoginUrl;
    private final String fixLoginUrl;
    private final String resetCookieUrl;

    private final Map<BlackboxSessionIdStatus, String> blackboxStatusLoginUrlMap =
            new EnumMap<>(BlackboxSessionIdStatus.class);

    public LoginUrlService(@Value("${auth.passport.url:}") String passportUrl) {
        baseUrl = StringUtils.trimTrailingCharacter(passportUrl, '/');
        defaultLoginUrl = baseUrl + DEFAULT_LOGIN_URL;
        fixLoginUrl = baseUrl + FIX_LOGIN_URL;
        resetCookieUrl = baseUrl + RESET_COOKIE_URL;
        fillBlackboxStatusLoginUrlMap();
    }

    public String getDefaultLoginUrl() {
        return defaultLoginUrl;
    }

    public String getFixLoginUrl() {
        return fixLoginUrl;
    }

    public String getResetCookieUrl() {
        return resetCookieUrl;
    }

    public String getLoginUrlForBlackboxStatus(BlackboxSessionIdStatus status) {
        return blackboxStatusLoginUrlMap.get(status);
    }

    private void fillBlackboxStatusLoginUrlMap() {
        blackboxStatusLoginUrlMap.put(BlackboxSessionIdStatus.NEED_RESET, getResetCookieUrl());
        blackboxStatusLoginUrlMap.put(BlackboxSessionIdStatus.EXPIRED, getResetCookieUrl());
        blackboxStatusLoginUrlMap.put(BlackboxSessionIdStatus.NOAUTH, getDefaultLoginUrl());
        blackboxStatusLoginUrlMap.put(BlackboxSessionIdStatus.INVALID, getFixLoginUrl());
        blackboxStatusLoginUrlMap.put(BlackboxSessionIdStatus.UNDEFINED, getFixLoginUrl());
    }

}
