package ru.yandex.partner.libs.auth.service;

import java.util.List;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class LoginUrlServiceTest {

    @Test
    public void testLoginUrls() {
        for (String baseUrl : List.of("https://passport.yandex.ru", "https://passport.yandex.ru/")) {
            LoginUrlService loginUrlService = new LoginUrlService(baseUrl);

            assertEquals("https://passport.yandex.ru/passport?mode=auth", loginUrlService.getDefaultLoginUrl());
            assertEquals("https://passport.yandex.ru/passport?mode=postregistration&create_login=1",
                    loginUrlService.getFixLoginUrl());
            assertEquals("https://passport.yandex.ru/auth/update/?", loginUrlService.getResetCookieUrl());
        }
    }


}
