package ru.yandex.partner.libs.authorization.actioncontext;

import java.util.Optional;
import java.util.function.Function;

public abstract class ActionRequest {
    private ActionRequest() {

    }

    public abstract <C> C match(
            Function<? super RequestContext, ? extends C> create,
            Function<? super RequestContext, ? extends C> get,
            Function<? super RequestContext, ? extends C> getAll,
            Function<? super RequestContext, ? extends C> update,
            Function<? super CustomRequestContext, ? extends C> custom
    );

    public static ActionRequest create(RequestContext context) {
        return new ActionRequest() {
            @Override
            public <C> C match(
                    Function<? super RequestContext, ? extends C> create,
                    Function<? super RequestContext, ? extends C> get,
                    Function<? super RequestContext, ? extends C> getAll,
                    Function<? super RequestContext, ? extends C> update,
                    Function<? super CustomRequestContext, ? extends C> custom
            ) {
                return create.apply(context);
            }
        };
    }

    public static ActionRequest get(RequestContext context) {
        return new ActionRequest() {
            @Override
            public <C> C match(
                    Function<? super RequestContext, ? extends C> create,
                    Function<? super RequestContext, ? extends C> get,
                    Function<? super RequestContext, ? extends C> getAll,
                    Function<? super RequestContext, ? extends C> update,
                    Function<? super CustomRequestContext, ? extends C> custom
            ) {
                return get.apply(context);
            }
        };
    }

    public static ActionRequest getAll(RequestContext context) {
        return new ActionRequest() {
            @Override
            public <C> C match(
                    Function<? super RequestContext, ? extends C> create,
                    Function<? super RequestContext, ? extends C> get,
                    Function<? super RequestContext, ? extends C> getAll,
                    Function<? super RequestContext, ? extends C> update,
                    Function<? super CustomRequestContext, ? extends C> custom
            ) {
                return getAll.apply(context);
            }
        };
    }

    public static ActionRequest update(RequestContext context) {
        return new ActionRequest() {
            @Override
            public <C> C match(
                    Function<? super RequestContext, ? extends C> create,
                    Function<? super RequestContext, ? extends C> get,
                    Function<? super RequestContext, ? extends C> getAll,
                    Function<? super RequestContext, ? extends C> update,
                    Function<? super CustomRequestContext, ? extends C> custom
            ) {
                return update.apply(context);
            }
        };
    }

    public static ActionRequest custom(CustomRequestContext context) {
        return new ActionRequest() {
            @Override
            public <C> C match(
                    Function<? super RequestContext, ? extends C> create,
                    Function<? super RequestContext, ? extends C> get,
                    Function<? super RequestContext, ? extends C> getAll,
                    Function<? super RequestContext, ? extends C> update,
                    Function<? super CustomRequestContext, ? extends C> custom
            ) {
                return custom.apply(context);
            }
        };
    }

    public Optional<RequestContext> isCreate() {
        return this.match(
                create -> Optional.of(create),
                get -> Optional.empty(),
                getAll -> Optional.empty(),
                update -> Optional.empty(),
                custom -> Optional.empty()
        );
    }

    public Optional<RequestContext> isGet() {
        return this.match(
                create -> Optional.empty(),
                get -> Optional.of(get),
                getAll -> Optional.empty(),
                update -> Optional.empty(),
                custom -> Optional.empty()
        );
    }

    public Optional<RequestContext> isGetAll() {
        return this.match(
                create -> Optional.empty(),
                get -> Optional.empty(),
                getAll -> Optional.of(getAll),
                update -> Optional.empty(),
                custom -> Optional.empty()
        );
    }

    public Optional<RequestContext> isUpdate() {
        return this.match(
                create -> Optional.empty(),
                get -> Optional.empty(),
                getAll -> Optional.empty(),
                update -> Optional.of(update),
                custom -> Optional.empty()
        );
    }

    public Optional<CustomRequestContext> isCustom() {
        return this.match(
                create -> Optional.empty(),
                get -> Optional.empty(),
                getAll -> Optional.empty(),
                update -> Optional.empty(),
                custom -> Optional.of(custom)
        );
    }
}
