package ru.yandex.partner.libs.authorization.actioncontext;

public interface AuthParam<T> {
    String key();

    Class<T> type();

    static <T> AuthParam<T> create(String key, Class<T> type) {
        return new AuthParam<>() {
            @Override
            public String key() {
                return key;
            }

            @Override
            public Class<T> type() {
                return type;
            }
        };
    }
}
