package ru.yandex.partner.libs.authorization.actioncontext;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.libs.auth.model.UserAuthentication;

@ParametersAreNonnullByDefault
public class CreateRequest<T> implements Authenticated {
    private final UserAuthentication userAuthentication;
    private final T createPayload;

    public CreateRequest(UserAuthentication userAuthentication, T createPayload) {
        this.userAuthentication = userAuthentication;
        this.createPayload = createPayload;
    }

    @Override
    public UserAuthentication getUserAuthentication() {
        return userAuthentication;
    }

    public T getCreatePayload() {
        return createPayload;
    }
}
