package ru.yandex.partner.libs.authorization.actioncontext;

import java.util.List;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.FieldsSet;

public class GetAllResult<S extends ModelWithId> implements Authenticated {
    private UserAuthentication userAuthentication;
    private FieldsSet fieldsSet;
    private List<S> gotCoreModels;

    public GetAllResult(
            UserAuthentication userAuthentication,
            FieldsSet fieldsSet,
            List<S> gotCoreModels
    ) {
        this.userAuthentication = userAuthentication;
        this.fieldsSet = fieldsSet;
        this.gotCoreModels = gotCoreModels;
    }

    @Override
    public UserAuthentication getUserAuthentication() {
        return userAuthentication;
    }

    public FieldsSet getFieldsSet() {
        return fieldsSet;
    }

    public List<S> getGotCoreModels() {
        return gotCoreModels;
    }
}
