package ru.yandex.partner.libs.authorization.actioncontext;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.partner.libs.auth.model.UserAuthentication;

public class RequestContext implements Authenticated {
    private final Map<String, Object> boundParams = new HashMap<>();
    private final UserAuthentication userAuthentication;

    public RequestContext(UserAuthentication userAuthentication) {
        this.userAuthentication = userAuthentication;
    }

    @Override
    public UserAuthentication getUserAuthentication() {
        return userAuthentication;
    }

    public <T> RequestContext withParam(AuthParam<T> param, T value) {
        boundParams.put(param.key(), value);
        return this;
    }

    public <T> T getParam(AuthParam<T> param) {
        return param.type().cast(boundParams.get(param.key()));
    }
}
