package ru.yandex.partner.libs.authorization.actioncontext;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.libs.auth.model.UserAuthentication;

@ParametersAreNonnullByDefault
public class UpdateRequest<T> implements Authenticated {
    private final UserAuthentication userAuthentication;
    private final T currentInstance;
    private final T updatePayload;

    public UpdateRequest(UserAuthentication userAuthentication, T currentInstance, T updatePayload) {
        this.userAuthentication = userAuthentication;
        this.currentInstance = currentInstance;
        this.updatePayload = updatePayload;
    }

    @Override
    public UserAuthentication getUserAuthentication() {
        return userAuthentication;
    }

    public T getCurrentInstance() {
        return currentInstance;
    }

    public T getUpdatePayload() {
        return updatePayload;
    }
}
