package ru.yandex.partner.libs.authorization.actioncontext;

import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.FieldsSet;

public class UpdateResult<T> implements Authenticated {
    private UserAuthentication userAuthentication;
    private FieldsSet fieldsSet;
    private T currentInstance;
    private T updatedInstance;

    public UpdateResult(UserAuthentication userAuthentication, FieldsSet fieldsSet, T currentInstance,
                        T updatedInstance) {
        this.userAuthentication = userAuthentication;
        this.fieldsSet = fieldsSet;
        this.currentInstance = currentInstance;
        this.updatedInstance = updatedInstance;
    }

    @Override
    public UserAuthentication getUserAuthentication() {
        return userAuthentication;
    }

    public FieldsSet getFieldsSet() {
        return fieldsSet;
    }

    public T getCurrentInstance() {
        return currentInstance;
    }

    public T getUpdatedInstance() {
        return updatedInstance;
    }
}
