package ru.yandex.partner.libs.authorization.policy.base;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.authorization.policy.contextual.CreateRequestPolicy;
import ru.yandex.partner.libs.authorization.policy.contextual.CreateResultPolicy;
import ru.yandex.partner.libs.authorization.policy.contextual.CustomRequestPolicy;
import ru.yandex.partner.libs.authorization.policy.contextual.CustomResultPolicy;
import ru.yandex.partner.libs.authorization.policy.contextual.GetAllRequestPolicy;
import ru.yandex.partner.libs.authorization.policy.contextual.GetAllResultPolicy;
import ru.yandex.partner.libs.authorization.policy.contextual.GetRequestPolicy;
import ru.yandex.partner.libs.authorization.policy.contextual.GetResultPolicy;
import ru.yandex.partner.libs.authorization.policy.contextual.UpdateRequestPolicy;
import ru.yandex.partner.libs.authorization.policy.contextual.UpdateResultPolicy;

public interface Policy<S extends ModelWithId> extends
        CreateRequestPolicy<S>,
        CreateResultPolicy<S>,
        GetRequestPolicy<S>,
        GetResultPolicy<S>,
        GetAllRequestPolicy<S>,
        GetAllResultPolicy<S>,
        UpdateRequestPolicy<S>,
        UpdateResultPolicy<S>,
        CustomRequestPolicy<S>,
        CustomResultPolicy<S> {

    Policy EMPTY_POLICY = new Policy<>() {
    };

    @Override
    default AuthorizationDecision<S> authorizeGetAllRequest(RequestContext getAllRequest) {
        return authorizeGetRequest(getAllRequest);
    }

    static <S extends ModelWithId> Policy<S> empty() {
        return (Policy<S>) EMPTY_POLICY;
    }
}
