package ru.yandex.partner.libs.authorization.policy.contextual;

import ru.yandex.partner.libs.authorization.actioncontext.CreateRequest;
import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

public interface CreateRequestPolicy<T> {
    default AuthorizationDecision<T> authorizeCreateRequest(RequestContext createRequest) {
        return AuthorizationDecision.unapplicable();
    }

    default AuthorizationDecision<T> authorizeCreateRequest(CreateRequest<T> createRequest) {
        return authorizeCreateRequest(new RequestContext(createRequest.getUserAuthentication()));
    }
}
