package ru.yandex.partner.libs.authorization.policy.contextual;

import ru.yandex.partner.libs.authorization.actioncontext.RequestContext;
import ru.yandex.partner.libs.authorization.actioncontext.UpdateRequest;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;

public interface UpdateRequestPolicy<T> {
    default AuthorizationDecision<T> authorizeUpdateRequest(RequestContext updateRequest) {
        return AuthorizationDecision.unapplicable();
    }

    default AuthorizationDecision<T> authorizeUpdateRequest(UpdateRequest<T> updateRequest) {
        return authorizeUpdateRequest(new RequestContext(updateRequest.getUserAuthentication()));
    }
}
