package ru.yandex.partner.libs.bs.json

import org.skyscreamer.jsonassert.Customization
import org.skyscreamer.jsonassert.JSONCompareMode
import org.skyscreamer.jsonassert.JSONCompareResult
import org.skyscreamer.jsonassert.LocationAwareValueMatcher

open class BkComparatorAndValueMatcher(
    allowedEmptyUnexpectedKeys: Set<String> = setOf(),
    allowedUnexpectedKeys: Set<String> = setOf(),
    allowedEmptyExpectedKeys: Set<String> = setOf(),
    allowedMissing: Set<String> = setOf(),
    matchKeysPaths: Set<String> = setOf(),
    matchKeys: Map<String, String> = mapOf(),
    mode: JSONCompareMode,
    vararg customizations: Customization
): BaseBkDataComparator(
    allowedEmptyUnexpectedKeys,
    allowedUnexpectedKeys,
    allowedEmptyExpectedKeys,
    allowedMissing,
    matchKeysPaths,
    matchKeys,
    mode,
    *customizations
), LocationAwareValueMatcher<Any> {
    override fun equal(
        prefix: String,
        actual: Any?,
        expected: Any?,
        result: JSONCompareResult
    ): Boolean {
        val subResult = JSONCompareResult()
        // кастомизации матчатся по relative пути
        compareValues("", expected, actual, subResult)
        // и переложим ошибки с правильными путями в основной результат
        subResult.fieldFailures
            .forEach { failure -> result.fail("${prefix}.${failure.field}", failure.expected, failure.actual) }
        subResult.fieldUnexpected
            .forEach { failure -> result.unexpected("${prefix}.${failure.field}", failure.actual) }
        subResult.fieldMissing
            .forEach { failure -> result.missing("${prefix}.${failure.field}", failure.expected) }

        if (!subResult.passed() && subResult.message.isNotBlank()) {
            result.fail(subResult.message)
        }

        return subResult.passed()
    }

    // implemented but not used for LocationAwareValueMatcher
    override fun equal(o1: Any?, o2: Any?) = false
}
