package ru.yandex.partner.libs.bs.json

import org.json.JSONArray
import org.skyscreamer.jsonassert.*
import java.util.*

class BlockBkDataComparator(
    arraysAsSet: ValueMatcher<Any> = object : LocationAwareValueMatcher<Any> {
        override fun equal(prefix: String, actual: Any?, expected: Any?, result: JSONCompareResult): Boolean {
            val equal = actual is JSONArray && expected is JSONArray
                && actual.length() == expected.length()
                && actual.asList().toSet() == expected.asList().toSet()

            if (!equal) {
                result.fail(prefix, expected, actual)
            }

            return equal
        }

        // implemented but not used for LocationAwareValueMatcher
        override fun equal(o1: Any?, o2: Any?) = false
    }
) : BkComparatorAndValueMatcher(
    /**
     * Таким ключам допустимо встречаться в actual, при условии, что они имеют "пустые" значения
     */
    allowedEmptyUnexpectedKeys = setOf(
        "AllowedImageType",
        "Article",
        "AdType",
        "AdTypeSet",
        "Brand",
        "Geo",
        "DSPInfo",
        "OrderTags",
        "PICategoryIAB",
        "Sizes",
        "TargetTags",
        "OrderTags",
        "Enable",
        "Disable",
        "DSPPageImpOptions",
        "API",
        "Protocols",
        "CustomBlockData"
        ),
    allowedUnexpectedKeys = setOf(
        /**
         * Для кейса запроса bkdata по блоку - в данных perl нет самого id блока
         */
        "BlockID",
        "PageImpOptions" // например у пейджа 213088
    ),
    allowedEmptyExpectedKeys = setOf(
        "AlternativeCode",
        "AdfoxPlaceID"
    ),
    /**
     * Таким ключам разрешено "пропадать" (под них нет места в proto)
     */
    allowedMissing = setOf(
        "campaign_id",
        "page_id",
        "application_id",
        "imageHeight",
        "CustomOptions"
    ),
    /**
     * По таким путям в префиксах меняются ключи currency, value - д.б. с большой буквы,
     * но в БД не всегда так
     */
    matchKeysPaths = setOf(
        "Article",
        "AdType",
        "AdTypeSet",
        "Brand",
        "Geo",
        "WrapperAds",
        "WrapperPromo",
        "DSPInfo"
    ),
    /**
     * Собственно маппинг ключей на ключи сериализации из proto, отличается только case-ом
     */
    matchKeys = mapOf(
        "DSPPageImpOptions" to "PageDspOptions"
    ),
    mode = JSONCompareMode.STRICT,
    customizations = arrayOf(
        Customization("PageImpOptions.Disable", arraysAsSet),
        Customization("PageImpOptions.Enable", arraysAsSet),
        Customization.customization("DSPSettings.DSP") { actual, expected ->
            // DSP array might be unordered, and id themselves are strings or numbers
            Objects.equals(
                (actual as JSONArray).asList().map { it.toString() }.sorted(),
                (expected as JSONArray).asList().map { it.toString() }.sorted()
            )
        }
    )
)

