package ru.yandex.partner.libs.bs.json

import org.json.JSONArray
import org.skyscreamer.jsonassert.Customization
import org.skyscreamer.jsonassert.JSONCompareMode
import org.skyscreamer.jsonassert.ValueMatcher
import java.util.*

class PageBkDataComparator(
    arrayOfNulls: ValueMatcher<Any> = ValueMatcher<Any> { actual, expected ->
        if (actual is JSONArray && actual.length() == 0 &&
            expected is JSONArray && (0 until expected.length()).all(expected::isNull)
        ) {
            true
        } else {
            Objects.equals(actual, expected)
        }
    }
) : BaseBkDataComparator(
    allowedEmptyUnexpectedKeys = setOf(
        "DirectBlocks",
        "BannerLang",
        "Options",
        "SSPPageToken",
        "VmapIDs",
        "RtbBlocks",
        "Mirrors",
        "TargetTags",
        "OrderTags",
        "DisabledFlags",
        "excludeddomains",
        "Slots",
        "PICategoryIAB"
    ),
    allowedEmptyExpectedKeys = setOf(
        "DSPInfo",
        // встречается с явным значением null, из протобафа пустое значение не сериализуется
        "AlternativeCode",
        "Description",
        "Domain",
        "Name",
        "Store",
    ),
    matchKeysPaths = setOf(""),
    mode = JSONCompareMode.STRICT,
    customizations = arrayOf(
        Customization.customization("RtbBlocks.***", BlockBkDataComparator()),
        Customization.customization("DirectBlocks.***", BlockBkDataComparator()),
        // TODO 2022-07-01: add support for allowedEmptyUnexpectedKeys by path
        Customization.customization("PageSelect", object: BkComparatorAndValueMatcher (
            allowedEmptyUnexpectedKeys = setOf("Unset"),
            mode = JSONCompareMode.STRICT
        ) {} ),
        // иногда встречается массивы [ null, null, null ], что равносильно пустому массиву
        Customization.customization("TargetTags", arrayOfNulls),
        Customization.customization("BannerLang", arrayOfNulls),
        // sometimes not an empty array but an empty string
        Customization.customization("SSPPageToken") { actual, expected ->
            if (expected is String && expected.isEmpty() && actual is JSONArray && actual.length() == 0) {
                true
            } else {
                Objects.equals(actual, expected)
            }
        }
    ),
)
