package ru.yandex.partner.libs.bs.ext

import NPartner.Page.TPartnerPage.TBlock
import ru.yandex.partner.libs.bs.ext.TBlockExt.Companion.getOrCreateAdTypeSet

fun TBlock.Builder.adTypeSet(
    adType: TBlock.EAdType
): TBlock.TAdTypeSet.Builder = getOrCreateAdTypeSet(this, adType)

class TBlockExt {
    companion object {
        @JvmStatic
        fun getOrCreateAdTypeSet(
            blockBuilder: TBlock.Builder,
            adType: TBlock.EAdType
        ): TBlock.TAdTypeSet.Builder =
            blockBuilder.adTypeSetBuilderList.find { it.hasAdType() && it.adType == adType }
                ?: blockBuilder.addAdTypeSetBuilder().setAdType(adType)
    }
}

