package ru.yandex.partner.libs.bs.json

import org.junit.jupiter.api.Test
import org.skyscreamer.jsonassert.JSONAssert
import org.skyscreamer.jsonassert.JSONCompareMode

internal class BkDataConverterTest {
    private val blockBkData = BkDataConverterTest::class.java.getResource("/block_data.json")!!
        .readText()
    private val pageBkData = BkDataConverterTest::class.java.getResource("/page_data.json")!!
        .readText()
    private val heavyPageBkData = BkDataConverterTest::class.java.getResource("/heavy_page_data.json")!!
        .readText()

    @Test
    fun convertBlockBackAndForth() {
        val afterConvert = BkDataConverter().convertBlockBackAndForth(blockBkData)
        JSONAssert.assertEquals(
            blockBkData,
            afterConvert,
            BlockBkDataComparator()
        )
    }

    @Test
    fun convertPageBackAndForth() {
        val afterConvert = BkDataConverter().convertPageBackAndForth(pageBkData)
        JSONAssert.assertEquals(
            pageBkData,
            afterConvert,
            PageBkDataComparator()
        )
    }

    @Test
    fun convertHeavyPageBackAndForth() {
        val afterConvert = BkDataConverter().convertPageBackAndForth(heavyPageBkData)
        JSONAssert.assertEquals(
            heavyPageBkData,
            afterConvert,
            PageBkDataComparator()
        )
    }

    /**
     * Проверяет преобразования json-дерева между perl-подобным и тем,
     * что используется для парсинга
     */
    @Test
    internal fun checkBlockBackAndForthDoesntLoseData() {
        val converter = BkDataConverter()
        val bkDataJson = converter.pbObjectMapper.readTree(blockBkData)
        val convertedBackAndForthBkData = bkDataJson
            .let(converter.blockBkDataConversion::forward)
            .let(converter.blockBkDataConversion::backward)

        JSONAssert.assertEquals(blockBkData, convertedBackAndForthBkData.toPrettyString(), JSONCompareMode.STRICT)
    }

    /**
     * Проверяет преобразования json-дерева между perl-подобным и тем,
     * что используется для парсинга
     */
    @Test
    internal fun checkPageBackAndForthDoesntLoseData() {
        val converter = BkDataConverter()
        val bkDataJson = converter.pbObjectMapper.readTree(pageBkData)
        val convertedBackAndForthBkData = bkDataJson
            .let(converter.pageBkDataConversion::forward)
            .let(converter.pageBkDataConversion::backward)

        JSONAssert.assertEquals(pageBkData, convertedBackAndForthBkData.toPrettyString(), PageBkDataComparator())
    }

    @Test
    internal fun checkHeavyPageBackAndForthDoesntLoseData() {
        val converter = BkDataConverter()
        val bkDataJson = converter.pbObjectMapper.readTree(heavyPageBkData)
        val convertedBackAndForthBkData = bkDataJson
            .let(converter.pageBkDataConversion::forward)
            .let(converter.pageBkDataConversion::backward)

        JSONAssert.assertEquals(heavyPageBkData, convertedBackAndForthBkData.toPrettyString(), PageBkDataComparator())
    }
}
