package ru.yandex.partner.libs.bs.json;


import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.util.DigestUtils;

import ru.yandex.partner.test.utils.TestUtils;

import static java.nio.file.StandardCopyOption.REPLACE_EXISTING;

/**
 * <p>
 *     Тест проверяет, что desc артифакт, используемый для парсинга протобуфных логов (в logfeller),
 *     не разъехался с proto схемой сообщения. Если красный - нужно перегенерить desc файл командой
 * </p>
 * <pre>$ SELF_UPDATE=1 ya make -tt</pre>
 * <p>
 *     из папки partner/java/libs/bspartner/convert
 * </p>
 * <p>
 *     Не работает при запуске из IDEA, так как невозможно получить ARCADIA_BUILD_ROOT без обвязки
 *     в виде ya make -tt. Тикет на это есть :) https://st.yandex-team.ru/ARCADIAPLUGINS-380
 * </p>
 *
 */
public class LogfellerDescTest {

    private static final String DESC_FILE_NAME = "partner-bk-proto-page-update.desc";
    private static final String ARCADIA_DESC_PATH = "logfeller/configs/parsers/" + DESC_FILE_NAME;

    @Test
    public void logfellerDescEquals() throws IOException, InterruptedException {

        Path sourceRoot = Path.of(System.getenv("ARCADIA_SOURCE_ROOT"));
        Path buildRoot = Path.of(System.getenv("ARCADIA_BUILD_ROOT"));
        Path logfellerDescFilePath = sourceRoot.resolve(ARCADIA_DESC_PATH);
        Path descFilePath = generateDescFile(sourceRoot, buildRoot);

        if (TestUtils.isTrueEnvironment("SELF_UPDATE")) {
            Path originalSourceRoot = Path.of(System.getenv("ORIGINAL_SOURCE_ROOT"));
            Path srcLogfellerDescFilePath = originalSourceRoot.resolve(ARCADIA_DESC_PATH);
            Files.move(descFilePath, srcLogfellerDescFilePath, REPLACE_EXISTING);
            Assertions.fail("Resource self_updated. Path = " + srcLogfellerDescFilePath);
        }
        Assertions.assertArrayEquals(
                fileHash(descFilePath), fileHash(logfellerDescFilePath),
                "%s differs. Please do self_update".formatted(DESC_FILE_NAME)
        );
    }

    private static Path generateDescFile(Path sourceRoot, Path buildRoot) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder();
        pb.inheritIO();
        pb.command(
                buildRoot.resolve("contrib/tools/protoc/bin/protoc").toString(),
                "--descriptor_set_out", DESC_FILE_NAME,
                "--proto_path", sourceRoot.toString(),
                "--proto_path", sourceRoot.resolve("contrib/libs/protobuf/src").toString(),
                "--include_imports",
                "--include_source_info", sourceRoot.resolve("adv/partner/proto/page.proto").toString()
        );
        Process process = pb.start();
        int resultCode = process.waitFor();
        Assertions.assertEquals(0, resultCode, "Process result code");
        return Path.of(DESC_FILE_NAME);
    }

    private static byte[] fileHash(Path filePath) throws IOException {
        try (var fs = new FileInputStream(filePath.toFile())) {
            return DigestUtils.md5Digest(fs);
        }
    }
}
