JAVA_LIBRARY()

INCLUDE(${ARCADIA_ROOT}/partner/java/common.inc)

WITH_KOTLIN()

PEERDIR(
    adv/partner/proto
    partner/java/libs/bspartner/compare

    contrib/java/com/google/protobuf/protobuf-java-util

    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/hubspot/jackson/jackson-datatype-protobuf/0.9.12

    contrib/java/org/slf4j/slf4j-api
    contrib/java/ch/qos/logback/logback-classic
)

EXCLUDE(
    contrib/java/com/google/code/findbugs/annotations
    contrib/java/com/google/code/findbugs/jsr305

    # hacky peerdir/include/exclude, to make a compile-time transitive dependency between
    # bspartner/compare and bspartner/convert/ut through bspartner/compare
    # and fix idea's buggy "Build Project" step
    # Otherwise, bspartner/compare project is not built before tests bspartner/convert/ut
    # which results in "unresolved reference BlockBkDataComparator|PageBkDataComparator"
    # However, this is a non-production dependency (test) and should be excluded in runtime
    partner/java/libs/bspartner/compare
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

END()

RECURSE_FOR_TESTS(ut)
