package ru.yandex.partner.libs.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class CliApp {

    public void run(String[] args) throws Exception {
        Options options = getOptions();
        options.addOption("h", "help", false, "Print help message");

        try {
            CommandLineParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(options, args, false);

            if (cmd.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("./run.sh " + this.getClass().getCanonicalName(), options, true);
                return;
            }

            configure(cmd);
            run();
        } catch (ParseException | CliAppException e) {
            System.out.println("Wrong usage: " + e.getMessage());
            System.exit(1);
        }
    }

    protected abstract Options getOptions();

    protected abstract void configure(CommandLine cmd) throws CliAppException;

    protected abstract void run() throws Exception;

}
