package ru.yandex.partner.libs.common;

import java.util.Optional;
import java.util.function.Supplier;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestContextUtils {

    private RequestContextUtils() {
    }

    public static boolean isRequestContextAvailable() {
        return getRequestAttributes().isPresent();
    }

    public static Optional<RequestAttributes> getRequestAttributes() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes());
    }

    public static Optional<HttpServletRequest> getRequest() {
        return getRequestAttributes()
                .filter(requestAttributes -> requestAttributes instanceof ServletRequestAttributes)
                .map(requestAttributes -> ((ServletRequestAttributes) requestAttributes).getRequest());
    }

    public static <T> Optional<T> getObject(String name, Class<T> clazz) {
        return getRequestAttributes()
                .map(requestAttributes -> (T) requestAttributes.getAttribute(name, RequestAttributes.SCOPE_REQUEST));
    }

    public static void putObject(String name, Object value) {
        getRequestAttributes().ifPresent(attributes -> attributes.setAttribute(name, value,
                RequestAttributes.SCOPE_REQUEST));
    }

    public static <T> T computeObject(String name, Class<T> clazz, Supplier<T> initializer) {
        return getObject(name, clazz).orElseGet(() -> {
            T value = initializer.get();
            putObject(name, value);
            return value;
        });
    }

}
