package ru.yandex.partner.libs.parser.models.page;

import ru.yandex.partner.libs.parser.models.MultiStateInterface;

public class ExternalPageModel implements MultiStateInterface {
    @Override
    public int getBytePositionByName(String name) {
        return MultiState.values().length - 1 - MultiState.valueOf(name).getBytePositionInArray();
    }

    @Override
    public int getByteMaskByName(String name) {
        return MultiState.valueOf(name).getByteMask();
    }

    @Override
    public byte length() {
        return (byte) MultiState.values().length;
    }


    private enum MultiState {
        WORKING(0),
        TESTING(1),
        STOPPED(2),
        DELETED(3),
        BALANCE_REGISTERED(4),
        READ_ONLY(5),
        CHECK_STATISTICS(6),
        BLOCKED(7),
        NEED_APPROVE(8),
        REJECTED(9),
        PROTECTION(10),
        NEED_UPDATE(11),
        UPDATING(12);

        private final int bytePositionInArray;
        private final int byteMask;

        MultiState(int bytePositionInArray) {
            this.bytePositionInArray = bytePositionInArray;
            this.byteMask = (int) Math.pow(2, bytePositionInArray);
        }

        private int getByteMask() {
            return byteMask;
        }

        private int getBytePositionInArray() {
            return bytePositionInArray;
        }

    }
}
