package ru.yandex.partner.libs.parser;

import java.util.ArrayList;
import java.util.List;

import org.junit.jupiter.api.Test;

import ru.yandex.partner.libs.parser.models.page.TestModel;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertIterableEquals;

class ParserTest {
    private static final List<String> QUERIES = new ArrayList<>() {{
        add("WORKING");
        add("WORKING and TESTING");
        add("(WORKING and TESTING)");
        add("WORKING and TESTING and STOPPED");
        add("WORKING and TESTING and STOPPED and deleted");

        add("WORKING");
        add("WORKING or TESTING");
        add("(WORKING or TESTING)");
        add("WORKING or TESTING or STOPPED");
        add("WORKING or TESTING or STOPPED or deleted");
        //10
        add("not WORKING");
        add("not WORKING or not TESTING");
        add("not (WORKING or TESTING)");
        add("not WORKING or not TESTING or not STOPPED");
        add("not WORKING or not TESTING or not STOPPED or not deleted");

        add("WORKING and (not deleted and TESTING)");
        add("WORKING and TESTING or DELETED");
        add("DELETED or WORKING and TESTING");
        add("(WORKING and TESTING) or DELETED");
        add("WORKING and (TESTING or DELETED)");

        add("WORKING and not (TESTING or DELETED)");
        add("not WORKING and not (TESTING or DELETED)");
    }};

    private static final List<List<Integer>> ANSWERS_LIST = new ArrayList<>() {{
        add(List.of(1, 3, 5, 7, 9, 11, 13, 15));
        add(List.of(3, 7, 11, 15));
        add(List.of(3, 7, 11, 15));
        add(List.of(7, 15));
        add(List.of(15));

        add(List.of(1, 3, 5, 7, 9, 11, 13, 15));
        add(List.of(1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15));
        add(List.of(1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15));
        add(List.of(1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15));
        add(List.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15));
        //10
        add(List.of(0, 2, 4, 6, 8, 10, 12, 14));
        add(List.of(0, 1, 2, 4, 5, 6, 8, 9, 10, 12, 13, 14));
        add(List.of(0, 4, 8, 12));
        add(List.of(0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14));
        add(List.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14));

        add(List.of(3, 7));
        add(List.of(3, 7, 8, 9, 10, 11, 12, 13, 14, 15));
        add(List.of(3, 7, 8, 9, 10, 11, 12, 13, 14, 15));
        add(List.of(3, 7, 8, 9, 10, 11, 12, 13, 14, 15));
        add(List.of(3, 7, 9, 11, 13, 15));

        add(List.of(1, 5));
        add(List.of(0, 4));
    }};

    private static final List<String> ANSWERS_BITS = new ArrayList<>() {{
        add("(multistate & 1)");
        add("(multistate & 1) AND (multistate & 2)");
        add("((multistate & 1) AND (multistate & 2))");
        add("(multistate & 1) AND (multistate & 2) AND (multistate & 4)");
        add("(multistate & 1) AND (multistate & 2) AND (multistate & 4) AND (multistate & 8)");

        add("(multistate & 1)");
        add("(multistate & 1) OR (multistate & 2)");
        add("((multistate & 1) OR (multistate & 2))");
        add("(multistate & 1) OR (multistate & 2) OR (multistate & 4)");
        add("(multistate & 1) OR (multistate & 2) OR (multistate & 4) OR (multistate & 8)");
        //10
        add("NOT (multistate & 1)");
        add("NOT (multistate & 1) OR NOT (multistate & 2)");
        add("NOT ((multistate & 1) OR (multistate & 2))");
        add("NOT (multistate & 1) OR NOT (multistate & 2) OR NOT (multistate & 4)");
        add("NOT (multistate & 1) OR NOT (multistate & 2) OR NOT (multistate & 4) OR NOT (multistate & 8)");

        add("(multistate & 1) AND (NOT (multistate & 8) AND (multistate & 2))");
        add("(multistate & 1) AND (multistate & 2) OR (multistate & 8)");
        add("(multistate & 8) OR (multistate & 1) AND (multistate & 2)");
        add("((multistate & 1) AND (multistate & 2)) OR (multistate & 8)");
        add("(multistate & 1) AND ((multistate & 2) OR (multistate & 8))");

        add("(multistate & 1) AND NOT ((multistate & 2) OR (multistate & 8))");
        add("NOT (multistate & 1) AND NOT ((multistate & 2) OR (multistate & 8))");
    }};

    @Test
    void test2() {
        Parser parser;
        for (int i = 0; i < QUERIES.size(); i++) {
            parser = new Parser(new TestModel());
            String testQ = ParserTest.QUERIES.get(i);
            testBits(i, parser, testQ);
            testIntegers(i, parser, testQ);
        }
    }

    private void testBits(int index, Parser parser, String testQ) {
        String query = parser.getBitsExpression(testQ).trim();
        assertEquals(ANSWERS_BITS.get(index).toUpperCase(), query.toUpperCase());
    }

    private void testIntegers(int index, Parser parser, String testQ) {
        List<Integer> list = parser.getAllNumbersForExpression(testQ);
        assertIterableEquals(ANSWERS_LIST.get(index), list);
    }
}
