package ru.yandex.partner.libs.parser.models.page;

import ru.yandex.partner.libs.parser.models.MultiStateInterface;

public class TestModel implements MultiStateInterface {
    @Override
    public int getBytePositionByName(String name) {
        return TestState.values().length - 1 - TestState.valueOf(name).getBytePositionInArray();
    }

    @Override
    public int getByteMaskByName(String name) {
        return TestState.valueOf(name).getByteMask();
    }

    @Override
    public byte length() {
        return (byte) TestState.values().length;
    }


    private enum TestState {
        WORKING(0),
        TESTING(1),
        STOPPED(2),
        DELETED(3);

        private final int bytePositionInArray;
        private final int byteMask;

        TestState(int bytePositionInArray) {
            this.bytePositionInArray = bytePositionInArray;
            this.byteMask = (int) Math.pow(2, bytePositionInArray);
        }

        private int getByteMask() {
            return byteMask;
        }

        private int getBytePositionInArray() {
            return bytePositionInArray;
        }
    }
}
