package ru.yandex.partner.core;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;

public class CoreConstants {
    public static final long ADINSIDE_USER_ID = 54519301L;
    public static final long ADINSIDE_CLIENT_ID = 944028;

    public static final long INTAPI_USER_ID = 337625302L;
    public static final long ADFOX_PIBOT_USER_ID = 959574841L;
    public static final long M_RU_TEXT_USER_ID = 28166288L;
    public static final int FIRM_ID_YANDEX_EUROPE_AG = 7;
    public static final long ASSESSOR_ROLE_ID = 44L;
    public static final long TECHNICAL_RTB_BLOCK_ID = 100_500L;
    public static final long SYSTEM_CRON_USER_ID = 0L;
    public static final String CAPTION = "caption";
    public static final String MIN_BANNERS = "min_banners";
    public static final String MAX_BANNERS = "max_banners";
    public static final String SKIP_FIELDS_CAPTION = "skip_fields";
    public static final String BLOCK_TYPES_CAPTION = "block_types";
    public static final String SHORT_CAPTION = "short_caption";
    public static final String BANNERS = "banners";
    public static final String ID_CAPTION = "id";
    public static final String SIZE_CAPTION = "size";

    public static final class Msf {
        public static final String RU_LANG = "ru";
        public static final String MSF_MANAGER_ROLE = "manager";
        public static final String MSF_PARTNER_ROLE = "partner";

        public Msf() {
        }
    }

    public static final Set<Long> BLIND_VALUES = Set.of(0L, 1L, 2L, 3L);

    public static final BigDecimal MIN_CPM =
            new BigDecimal("0." + StringUtils.repeat('0', CoreConstants.CPM_MAX_SCALE - 1) + "1");
    public static final BigDecimal MAX_CPM = BigDecimal.valueOf(9999L);
    public static final BigDecimal BK_MAX_CPM = MAX_CPM.multiply(BigDecimal.valueOf(1000L));
    public static final int CPM_MAX_SCALE = 3;
    public static final BigDecimal BLOCKED_CPM_VALUE = BigDecimal.valueOf(-1L);

    public static final String BK_RTB_DESIGN_NAME = "RtbDesign";
    public static final String BK_DEFAULT_DESIGN_NAME = "Design";
    public static final Map<String, String> BK_SLIDER_VALUE =
            Map.of("type", "default", "selectType", "default");

    public static final int LIMIT_CAMPAIGN_FOR_ADDING = 100;

    public static final DesignTemplatesType DEFAULT_DESIGN_TEMPLATES_TYPE = DesignTemplatesType.tga;

    public enum DspTypes {
        DSP_MEDIA(0L),
        DSP_VIDEO(1L),
        DSP_MOBILE(2L);

        public final long typeId;

        DspTypes(long typeId) {
            this.typeId = typeId;
        }

        public int bkId() {
            return 1 << typeId;
        }
    }

    public static class DspFormats {
        public static final long BANNER = 1L;
        public static final long NATIVE = 2L;
        public static final long VIDEO = 3L;

        public static final Map<Long, Long> TYPE_MAP = Map.of(
                BANNER, DspTypes.DSP_MEDIA.typeId,
                NATIVE, 3L, // pseudo type, flag for DSP_NATIVE_FORMAT_ID
                VIDEO, DspTypes.DSP_VIDEO.typeId
        );
    }

    public static class Currency {
        public static final String DEFAULT = "RUB";

        public Currency() {
            // Constants
        }
    }

    public enum VideoBlockTypes {
        PREROLL("preroll"),
        POSTROLL("postroll"),
        MIDROLL("midroll"),
        INTERSTITIAL("interstitial"),
        PAUSE("pauseroll"),
        INPAGE("inpage"),
        INROLL("inroll"),
        S2SROLL("s2sroll"),
        OVERLAY("overlay"),
        INROLL_OVERLAY("inroll-overlay"),
        POST_PAUSEROLL("postPauseroll");

        private final String bkCode;

        private static final Map<String, VideoBlockTypes> BY_BK_CODE =
                Arrays.stream(values()).collect(Collectors.toMap(it -> it.bkCode, Function.identity()));

        VideoBlockTypes(String bkCode) {
            this.bkCode = bkCode;
        }

        @Nullable
        public static VideoBlockTypes of(String bkCode) {
            return BY_BK_CODE.get(bkCode);
        }
    }

    public static final long DSP_DIRECT_ID = 1;
    public static final long DSP_AWAPS_ID = 2;
    public static final long DSP_OWN_ADV_ID = 5;
    public static final long DSP_UNSOLD_ID = 10;
    public static final long DSP_AWAPS_PMP_ID = 2563149;
    public static final long DSP_AWAPS_MOBILE_ID = 2563084;
    public static final long DSP_CRITEO_NATIVE = 2563330;
    public static final long VIDEO_INTERSTITIAL_MOBILE_ID = 2563154;

    public static final List<Long> DSP_TYPES = Arrays.stream(DspTypes.values()).map(it -> it.typeId)
            .collect(Collectors.toList());

    public static final List<String> INTERNAL_DSP_TAGS = List.of("yabs", "awaps", "local", "dc_dsp_test");

    public static final List<Long> VIDEO_AWAPS_DSPS = List.of(2563180L, 2563201L);
    public static final Set<Long> INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = Set.of(2563117L, 2563070L);
    public static final Set<Long> EXTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = Set.of(
            2563117L, 2563070L,
            2563219L,
            2563167L,
            2563178L,
            2563185L,
            2563190L,
            2563254L,
            2563269L,
            2563281L,
            2563130L
    );
    public static final Set<Long> INTERNAL_MOBILE_DEFAULT_DSPS = Set.of(DSP_DIRECT_ID, DSP_AWAPS_MOBILE_ID);
    public static final Set<Long> VIDEO_INTERSTITIAL_DSPS = Set.of();
    public static final Set<Long> VIDEO_BANNER_DSPS = Set.of();

    public static String MEDIA_IMAGE_REACH = "MediaImageReach";
    public static String MEDIA_CREATIVE_REACH = "MediaCreativeReach";
    public static String VIDEO_CREATIVE_REACH = "VideoCreativeReach";

    public static Set<String> RTB_PRODUCT_TYPES = Set.of(MEDIA_IMAGE_REACH, MEDIA_CREATIVE_REACH);
    public static Set<String> VIDEO_PRODUCT_TYPES = Set.of(VIDEO_CREATIVE_REACH);
    public static int CPM_MULTIPLIER = 1000;
    public static long STRIPE_PLACE_ID = 1127L;

    public static class Strategies {
        public static final Long MIN_CPM_STRATEGY_ID = 0L;
        public static final Long MAX_REVENUE_STRATEGY_ID = 1L;
        public static final Long SEPARATE_CPM_STRATEGY_ID = 3L;

        private Strategies() {
            // Constants
        }
    }

    public static class BalanceClassType {
        public static final String COLLATERAL = "COLLATERAL";

        private BalanceClassType() {
            // Constants
        }
    }

    public enum VideoPlatforms {
        VIDEO_PLATFORM_FLASH("flash"),
        VIDEO_PLATFORM_HTML5("html5"),
        VIDEO_PLATFORM_MOBILE("mobile_apps"),
        VIDEO_PLATFORM_SMART_TV("smart_tv");

        public final String type;

        VideoPlatforms(String type) {
            this.type = type;
        }
    }

    public static String DEFAULT_VIDEO_SKIN = "http://storage.mds.yandex.net/get-partner/14408/default.swf";

    public static class BalanceContractType {
        public static final int UR = 1;             // С Юр. лицом
        public static final int AGGREGATOR = 2;     // С Агрегатором
        public static final int PH = 3;             // С Физ. лицом
        public static final int NONRESIDENT = 4;    // С нерезидентом
        public static final int UNIVERSAL = 5;      // универсальный
        public static final int YAN_2014 = 6;       // РСЯ 2014
        public static final int NEW_OFFER = 7;      // Новая оферта РСЯ
        public static final int SSP = 8;            // SSP
        public static final int OFFER = 9;          // Единая оферта
        public static final int LICENSE = 10;       // Лицензионный договор

        private BalanceContractType() {
            // Constants
        }
    }

    public static final Long BELARUS_ID = 149L;
    public static final Long KAZAKHSTAN_ID = 159L;
    public static final Long UKRAINE_ID = 187L;
    public static final Long RUSSIA_ID = 225L;

    public static final Set<Long> CRIMEA_TO_RUSSIA = Set.of(
            RUSSIA_ID, BELARUS_ID, KAZAKHSTAN_ID
    );

    public static final Long CRIMEA_ID = 977L;

    public static final String EDIT_PROTECTED_PAGES_RIGHT_NAME = "edit_protected_pages";

    public static final String RFC822PAT = "[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\" +
            "([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))" +
            "[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:(?:[^(\\040)<>@,;:\"" +
            ".\\\\\\[\\]\\000-\\037\\x80-\\xff]+(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff])" +
            "|\"[^\\\\\\x80-\\xff\\n\\015\"]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015\"]*)*\")[\\040\\t]*(?:\\" +
            "([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*" +
            "(?:\\.[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\" +
            "([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))" +
            "[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+" +
            "(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\"[^\\\\\\x80-\\xff\\n\\015\"]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015\"]*)*\")[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:" +
            "(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()" +
            "]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*)*@[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015" +
            "()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:[^(\\040)<>@,;:\"" +
            ".\\\\\\[\\]\\000-\\037\\x80-\\xff]+(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\\[" +
            "(?:[^\\\\\\x80-\\xff\\n\\015\\[\\]]|\\\\[^\\x80-\\xff])*\\])[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()" +
            "]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*" +
            "(?:\\.[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\" +
            "([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))" +
            "[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+" +
            "(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\\[" +
            "(?:[^\\\\\\x80-\\xff\\n\\015\\[\\]]|\\\\[^\\x80-\\xff])*\\])[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()" +
            "]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*)" +
            "*|(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+(?![^(\\040)<>@,;:\"" +
            ".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\"[^\\\\\\x80-\\xff\\n\\015\"]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015\"]*)*\")[^()<>@,;:\"" +
            ".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]*(?:(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:" +
            "(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()" +
            "]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)|\"[^\\\\\\x80-\\xff\\n\\015\"]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015\"]*)*\")[^()<>@,;:\"" +
            ".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]*)*<[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:" +
            "(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()" +
            "]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:@[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()" +
            "]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*" +
            "(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+(?![^(\\040)<>@,;:\"" +
            ".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\\[(?:[^\\\\\\x80-\\xff\\n\\015\\[\\]]|\\\\[^\\x80-\\xff])*\\])" +
            "[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*" +
            "(?:\\.[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\" +
            "([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))" +
            "[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+" +
            "(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\\[" +
            "(?:[^\\\\\\x80-\\xff\\n\\015\\[\\]]|\\\\[^\\x80-\\xff])*\\])[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()" +
            "]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*)" +
            "*(?:,[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015" +
            "()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)" +
            "[\\040\\t]*)*@[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\" +
            "([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))" +
            "[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+" +
            "(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\\[" +
            "(?:[^\\\\\\x80-\\xff\\n\\015\\[\\]]|\\\\[^\\x80-\\xff])*\\])[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()" +
            "]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*" +
            "(?:\\.[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\" +
            "([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))" +
            "[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+" +
            "(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\\[" +
            "(?:[^\\\\\\x80-\\xff\\n\\015\\[\\]]|\\\\[^\\x80-\\xff])*\\])[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()" +
            "]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*)" +
            "*)*:[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015" +
            "()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)" +
            "[\\040\\t]*)*)?(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+(?![^(\\040)<>@,;:\"" +
            ".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\"[^\\\\\\x80-\\xff\\n\\015\"]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015\"]*)*\")[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:" +
            "(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()" +
            "]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:\\.[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015" +
            "()]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*" +
            "(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+(?![^(\\040)<>@,;:\"" +
            ".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\"[^\\\\\\x80-\\xff\\n\\015\"]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015\"]*)*\")[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:" +
            "(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()" +
            "]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*)*@[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015" +
            "()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:[^(\\040)<>@,;:\"" +
            ".\\\\\\[\\]\\000-\\037\\x80-\\xff]+(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\\[" +
            "(?:[^\\\\\\x80-\\xff\\n\\015\\[\\]]|\\\\[^\\x80-\\xff])*\\])[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()" +
            "]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*" +
            "(?:\\.[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()]*(?:(?:\\\\[^\\x80-\\xff]|\\" +
            "([^\\\\\\x80-\\xff\\n\\015()]*(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))" +
            "[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*(?:[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+" +
            "(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff])|\\[" +
            "(?:[^\\\\\\x80-\\xff\\n\\015\\[\\]]|\\\\[^\\x80-\\xff])*\\])[\\040\\t]*(?:\\([^\\\\\\x80-\\xff\\n\\015()" +
            "]*(?:(?:\\\\[^\\x80-\\xff]|\\([^\\\\\\x80-\\xff\\n\\015()]*" +
            "(?:\\\\[^\\x80-\\xff][^\\\\\\x80-\\xff\\n\\015()]*)*\\))[^\\\\\\x80-\\xff\\n\\015()]*)*\\)[\\040\\t]*)*)" +
            "*>)";

    public static final int SELF_EMPLOYED_STATUS_READY = 2;


    public static class MobileAppModes {
        public static final Integer ANYTHING = 0; // любая
        public static final Integer ONLY_MOBILE_APP_ADD = 1; // только реклама Мобильных Приложений
        public static final Integer WITHOUT_MOBILE_APP_ADD = 2; // без МП

        private MobileAppModes() {
            // Constants
        }
    }

    public static final String DESIGN_SETTING_NAME_PARAM = "name";
    public static final String DESIGN_SETTING_LIMIT_PARAM = "limit";
    public static final String DESIGN_SETTING_FLOORAD_PARAM = "floorAd";
    public static final String DESIGN_SETTING_LAYOUT_PARAM = "layout";
    public static final String DESIGN_SETTING_REWARDED_PARAM = "rewarded";
    public static final String DESIGN_SETTING_FULLSCREEN_PARAM = "fullscreen";

    private CoreConstants() {
        // just constants
    }
}
