package ru.yandex.partner.core.action;

import java.util.Objects;

import ru.yandex.partner.libs.i18n.GettextMsg;

public class Action {
    private final String name;
    private final GettextMsg title;

    public Action(String name, GettextMsg title) {
        this.name = name;
        this.title = title;
    }

    public String getName() {
        return name;
    }

    public GettextMsg getTitle() {
        return title;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action action = (Action) o;
        return Objects.equals(name, action.name) &&
                Objects.equals(title, action.title);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, title);
    }

    @Override
    public String toString() {
        return "Action{" +
                "name='" + name + '\'' +
                ", title=" + title +
                '}';
    }
}
