package ru.yandex.partner.core.block

import org.springframework.stereotype.Component
import ru.yandex.partner.core.entity.block.model.BaseBlock
import ru.yandex.partner.core.modelmeta.ModelMetaCollector
import ru.yandex.partner.core.modelmeta.ModelTypesHolder
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbModel

@Component
class BlockModelTypesHolder(
    private val mapping: Map<Class<out BaseBlock>, ContextOnSiteRtbModel>
    = ModelMetaCollector.getModelMetaHolders()
        .filter { BaseBlock::class.java.isAssignableFrom(it.entityClass) }.associate {
            @Suppress("UNCHECKED_CAST")
            it.entityClass as Class<out BaseBlock> to ContextOnSiteRtbModel.valueOf(it.name)
        }
) :
    ModelTypesHolder<BaseBlock, ContextOnSiteRtbModel> {

    override fun getTypeForDb(clazz: Class<out BaseBlock>): ContextOnSiteRtbModel? {
        return mapping[clazz]
    }
}
