package ru.yandex.partner.core.block;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.ContentBlock;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.model.RtbBlock;

public enum BlockType {
    CONTEXT_ON_SITE_RTB("context_on_site_rtb", true, RtbBlock::new),
    INTERNAL_CONTEXT_ON_SITE_RTB("internal_context_on_site_rtb", false, InternalRtbBlock::new),
    CONTEXT_ON_SITE_CONTENT("context_on_site_content", true, ContentBlock::new),
    CONTEXT_ON_SITE_STRIPE("context_on_site_stripe", true, null),
    CONTEXT_ON_SITE_DIRECT("context_on_site_direct", true, null),
    MOBILE_APP_RTB("mobile_app_rtb", true, MobileRtbBlock::new),
    INTERNAL_MOBILE_APP_RTB("internal_mobile_app_rtb", false, InternalMobileRtbBlock::new),
    SEARCH_ON_SITE_DIRECT("search_on_site_direct", true, null),
    SEARCH_ON_SITE_MARKET("search_on_site_market", true, null),
    SEARCH_ON_SITE_MCB("search_on_site_mcb", true, null),
    SEARCH_ON_SITE_PREMIUM("search_on_site_premium", true, null),
    VIDEO_AN_SITE_INSTREAM("video_an_site_instream", true, null),
    VIDEO_AN_SITE_INPAGE("video_an_site_inpage", true, null),
    VIDEO_AN_SITE_FULLSCREEN("video_an_site_fullscreen", true, null),
    CONTEXT_ON_SITE_ADBLOCK("context_on_site_adblock", true, null),
    INDOOR_BLOCK("indoor_block", true, null),
    OUTDOOR_BLOCK("outdoor_block", true, null),
    CONTEXT_ON_SITE_NATURAL("context_on_site_natural", true, null),
    INTERNAL_CONTEXT_ON_SITE_DIRECT("internal_context_on_site_direct", false, null),
    INTERNAL_SEARCH_ON_SITE_DIRECT("internal_search_on_site_direct", false, null),
    INTERNAL_SEARCH_ON_SITE_PREMIUM("internal_search_on_site_premium", false, null),
    SSP_RTB("ssp_rtb", false, null);

    private static final Map<String, BlockType> LITERAL_MAP = Arrays.stream(values())
            .collect(Collectors.toUnmodifiableMap(BlockType::getLiteral, Function.identity()));

    private final String literal;
    /**
     * Внешний контракт
     * На основе которого может быть автоматическая остановка блоков по окончании договора
     * {@link ParsedProductRunClearance}
     */
    @SuppressWarnings("JavadocReference")
    private final boolean hasContract;
    private final Supplier<BaseBlock> constructor;

    public static BlockType from(String literal) {
        return LITERAL_MAP.get(literal);
    }

    BlockType(String literal, boolean hasContract, Supplier<BaseBlock> constructor) {
        this.literal = literal;
        this.hasContract = hasContract;
        this.constructor = constructor;
    }

    public String getLiteral() {
        return literal;
    }

    public boolean isHasContract() {
        return hasContract;
    }

    @Nullable
    public Supplier<BaseBlock> getConstructor() {
        return constructor;
    }
}
