package ru.yandex.partner.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockType;


public enum DspBlock {
    _320x480("320x480","320×480", Set.of(MobileBlockType.INTERSTITIAL, MobileBlockType.REWARDED), null),
    _480x320("480x320","480×320", Set.of(MobileBlockType.INTERSTITIAL, MobileBlockType.REWARDED), null),
    _400x240("400x240","400×240", Set.of(MobileBlockType.INTERSTITIAL, MobileBlockType.REWARDED), null),
    _240x400("240x400","240×400", Set.of(MobileBlockType.INTERSTITIAL, MobileBlockType.REWARDED), null),
    _320x100("320x100","320×100", Set.of(MobileBlockType.BANNER, MobileBlockType.NATIVE), null),
    _320x50("320x50","320×50",Set.of(MobileBlockType.BANNER, MobileBlockType.NATIVE), null),
    _300x300("300x300","300×300", Set.of(MobileBlockType.INTERSTITIAL, MobileBlockType.REWARDED,
            MobileBlockType.BANNER, MobileBlockType.NATIVE), null),
    _300x250("300x250","300×250", Set.of(MobileBlockType.INTERSTITIAL, MobileBlockType.REWARDED,
            MobileBlockType.BANNER, MobileBlockType.NATIVE), null),
    _728x90("728x90","728×90", Set.of(MobileBlockType.BANNER, MobileBlockType.NATIVE), null),
    NATIVE("native","Native", Set.of(MobileBlockType.NATIVE), "0x0"),
    ADAPTIVE0418("adaptive0418","adaptive_banner", Set.of(MobileBlockType.ADAPTIVE_BANNER), null);


    private final String id;
    private final String caption;
    private final String size;
    private final Set<MobileBlockType> mobileBlockTypes;

    DspBlock(String id, String caption, Set<MobileBlockType> mobileBlockTypes, String size)  {
        this.id = id;
        this.caption = caption;
        this.size = size;
        this.mobileBlockTypes = mobileBlockTypes;
    }

    public <M extends BlockWithBlockType> boolean isAllowedBlockType(M block){;
        return mobileBlockTypes.stream().anyMatch(blockType -> blockType.hasType(block));
    }

    public Set<MobileBlockType> getMobileBlockTypes() {
        return mobileBlockTypes;
    }

    public Map<String, Object> toDefaultsMap() {
        Map<String, Object> map = new HashMap<>();
        map.put(CoreConstants.ID_CAPTION, id);
        map.put(CoreConstants.SHORT_CAPTION, caption);
        map.put(CoreConstants.BLOCK_TYPES_CAPTION, mobileBlockTypes.stream()
                        .map(b -> b.getLiteral()).collect(Collectors.toList()));
        if(size != null)
            map.put(CoreConstants.SIZE_CAPTION, size);
        return map;
    }
}
