package ru.yandex.partner.core.block.direct;

class Banners {
    private Integer min;
    private Integer max;
    private Integer exact;

    Banners(int min, int max) {
        this.min = min;
        this.max = max;
    }

    Banners(int exact) {
        this.exact = exact;
    }

    Banners(int min, int max, int exact) {
        this.min = min;
        this.max = max;
        this.exact = exact;
    }

    static Banners upTo(int max) {
        return new Banners(1, max);
    }

    static Banners of(int exact) {
        return new Banners(exact);
    }

    Integer getDirectLimit() {
        return exact != null ? exact : max;
    }

    Integer getMin() {
        return min;
    }

    Integer getMax() {
        return max;
    }

    Integer getExact() {
        return exact;
    }
}
