package ru.yandex.partner.core.block.direct;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import org.springframework.context.support.MessageSourceAccessor;

import ru.yandex.partner.core.entity.block.model.BlockWithDirectBlock;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class DirectBlock {
    private final DirectBlockId id;
    private final GettextMsg shortCaption;
    private final GettextMsg caption;
    private final Banners banners;
    private final List<String> skipFields;

    DirectBlock(DirectBlockId id, GettextMsg shortCaption, GettextMsg caption, Banners banners,
                List<String> skipFields) {
        this.id = id;
        this.shortCaption = shortCaption;
        this.caption = caption;
        this.banners = banners;
        this.skipFields = skipFields;
    }

    DirectBlock(DirectBlockId id, GettextMsg shortCaption, GettextMsg caption, Banners banners) {
        this(id, shortCaption, caption, banners, List.of());
    }

    public <M extends BlockWithDirectBlock> boolean isAllowedBlockType(M block) {
        return id.getMobileBlockTypes().stream().anyMatch(blockType -> blockType.hasType(block));
    }

    public String getName() {
        return id.getName();
    }

    public Integer getDirectLimit() {
        return banners.getDirectLimit();
    }

    public Object toDto(MessageSourceAccessor translations) {
        return new DirectBlockDto(
                banners.getExact(),
                translations.getMessage(caption),
                id.getName(),
                banners.getMax(),
                banners.getMin(),
                translations.getMessage(shortCaption),
                skipFields
        );
    }

}

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonNaming(PropertyNamingStrategies.SnakeCaseStrategy.class)
class DirectBlockDto {
    Integer banners;
    String caption;
    String id;
    Integer maxBanners;
    Integer minBanners;
    String shortCaption;
    List<String> skipFields;

    DirectBlockDto(Integer banners, String caption, String id, Integer maxBanners, Integer minBanners,
                          String shortCaption, List<String> skipFields) {
        this.banners = banners;
        this.caption = caption;
        this.id = id;
        this.maxBanners = maxBanners;
        this.minBanners = minBanners;
        this.shortCaption = shortCaption;
        this.skipFields = skipFields;
    }

    public Integer getBanners() {
        return banners;
    }

    public String getCaption() {
        return caption;
    }

    public String getId() {
        return id;
    }

    public Integer getMaxBanners() {
        return maxBanners;
    }

    public Integer getMinBanners() {
        return minBanners;
    }

    public String getShortCaption() {
        return shortCaption;
    }

    public List<String> getSkipFields() {
        return skipFields;
    }
}
