package ru.yandex.partner.core.block.direct;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum DirectBlockCaptionMsg implements GettextMsg {

    _240x400(msg("240×400 (to 2 banners)"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    _320x100(msg("320×100 (1 banner)"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    _320x50(msg("320×50 (1 banner)"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    _300x300(msg("300×300 (to 2 banners)"), "lib__Application__Model__Product__BlockTypes__InternalContextOnSiteRTB.pm"),
    _300x250(msg("300×250 (1 banner)"), "lib__Application__Model__Product__BlockTypes__InternalContextOnSiteRTB.pm"),
    _400x240(msg("400×240 (to 2 banners)"), "lib__Application__Model__Product__BlockTypes__MobileAppRTB.pm"),
    _728x90(msg("728×90 (1 banner)"), "lib__Application__Model__Product__AN__ContextOnSite__Direct.pm"),
    _320x480(msg("320×480 (1 banner)"), "lib__Application__Model__Product__AN__MobileApp__RTB.pm"),
    _480x320(msg("480×320 (to 2 banners)"), "lib__Application__Model__Product__BlockTypes__MobileAppRTB.pm"),
    HORIZONTAL(msg("Horizontal (to 4 banners)"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    VERTICAL(msg("Vertical (to 9 banners)"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    ADAPTIVE(msg("Adaptive (1-9 banners)"), "lib__Application__Model__Product__AN__ContextOnSite__Direct.pm"),
    NATIVE(msg("Native"), "lib__Application__Model__Product__InternalAN__MobileApp__RTB.pm"),
    ADAPTIVE0418(msg("Adaptive banner (1 banner)"), "lib__Application__Model__Product__BlockTypes__MobileAppRTB.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    DirectBlockCaptionMsg(GettextMsgPayload.Builder payload, String keyset) {
        this.payload = payload.build();
        this.keyset = keyset;
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
