package ru.yandex.partner.core.block.direct;

import java.util.List;

import ru.yandex.partner.core.block.MobileBlockType;

enum DirectBlockId {

    _240x400("240x400", List.of(MobileBlockType.INTERSTITIAL)),
    _320x100("320x100", List.of(MobileBlockType.BANNER)),
    _320x50("320x50", List.of(MobileBlockType.BANNER)),
    _300x300("300x300", List.of(MobileBlockType.BANNER, MobileBlockType.INTERSTITIAL)),
    _300x250("300x250", List.of(MobileBlockType.BANNER, MobileBlockType.INTERSTITIAL)),
    _400x240("400x240", List.of(MobileBlockType.INTERSTITIAL)),
    _728x90("728x90", List.of(MobileBlockType.BANNER)),
    _320x480("320x480", List.of(MobileBlockType.INTERSTITIAL, MobileBlockType.REWARDED)),
    _480x320("480x320", List.of(MobileBlockType.INTERSTITIAL)),
    HORIZONTAL("horizontal", List.of(MobileBlockType.BANNER)),
    VERTICAL("vertical", List.of(MobileBlockType.BANNER)),
    ADAPTIVE("adaptive", List.of(MobileBlockType.BANNER, MobileBlockType.INTERSTITIAL)),
    NATIVE("native", List.of(MobileBlockType.NATIVE)),
    ADAPTIVE0418("adaptive0418", List.of(MobileBlockType.ADAPTIVE_BANNER));

    private final String name;
    private final List<MobileBlockType> mobileBlockTypes;


    DirectBlockId(String name, List<MobileBlockType> mobileBlockTypes) {
        this.name = name;
        this.mobileBlockTypes = mobileBlockTypes;
    }

    public List<MobileBlockType> getMobileBlockTypes() {
        return mobileBlockTypes;
    }

    public String getName() {
        return name;
    }
}
