package ru.yandex.partner.core.block.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum BlockTypeMsg implements GettextMsg {
    NATIVE(msg("block_type_native")),
    INTERSTITIAL(msg("block_type_interstitial")),
    BANNER(msg("block_type_banner")),
    REWARDED(msg("block_type_rewarded"), Constants.BLOCK_TYPES_SETTINGS_KEYSET),
    ADAPTIVE_BANNER(msg("block_type_adaptive_banner"), Constants.BLOCK_TYPES_SETTINGS_KEYSET);

    private final GettextMsgPayload payload;
    private final String keyset;

    BlockTypeMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    BlockTypeMsg(GettextMsgPayload.Builder builder) {
        this(builder, Constants.COMMON_KEYSET);
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }

    private static class Constants {
        private static final String COMMON_KEYSET = "lib__Application__Model__Product__AN__MobileApp__Settings.pm";
        private static final String BLOCK_TYPES_SETTINGS_KEYSET =
                "lib__Application__Model__Product__AN__MobileApp__BlockTypes__Settings.pm";
    }
}
