package ru.yandex.partner.core.dictionary.moderationreason;

import java.util.Map;

import javax.annotation.Nonnull;

import ru.yandex.partner.core.DbLocale;

public class ModerationReason {

    private final Long id;
    private final Map<DbLocale, String> managerTxt;
    private final Map<DbLocale, String> partnerTxt;

    @Nonnull
    public ModerationReason(Long id, Map<DbLocale, String> managerTxt, Map<DbLocale, String> partnerTxt) {
        this.id = id;
        this.managerTxt = managerTxt;
        this.partnerTxt = partnerTxt;
    }

    public Long getId() {
        return id;
    }

    public String getManagerTxt(DbLocale locale) {
        return managerTxt.get(locale);
    }

    public String getPartnerTxt(DbLocale locale) {
        return partnerTxt.get(locale);
    }
}
