package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

/**
 * Please note: in this enum, CONTEXT is being set
 */
public enum BlockStateMsg implements GettextMsg {
    NEW(msg("New")),
    ARCHIVED(msg("Archived")),
    WORKING(msg("Working")),
    CHECK_STATISTICS(msg("Check statistics")),
    ARCHIVED_WITH_PAGE(msg("Archived with page")),
    NEED_UPDATE(msg("Need update")),
    UPDATING(msg("Updating"));

    private static final String CONTEXT = "Block multistate";
    private static final String KEYSET_NAME = "lib__Application__Model__Product__RTB.pm";

    private final GettextMsgPayload payload;

    BlockStateMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder
                .context(CONTEXT)
                .build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }

}
